package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.FunctionCode;
import com.xforceplus.ultraman.app.imageservicesaas.service.IFunctionCodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class FunctionCodeController {

  @Autowired
  private IFunctionCodeService functionCodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param functionCode ${table.comment}
   * @return
   */
  @GetMapping("/functioncodes" )
  public XfR getFunctionCodes(XfPage page, FunctionCode functionCode) {
    return XfR.ok(functionCodeServiceImpl.page(page, Wrappers.query(functionCode)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/functioncodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(functionCodeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param functionCode ${table.comment}
   * @return XfR
   */
  @PostMapping("/functioncodes")
  public XfR save(@RequestBody FunctionCode functionCode) {
     return XfR.ok(functionCodeServiceImpl.save(functionCode));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param functionCode ${table.comment}
   * @return XfR
   */
  @PutMapping("/functioncodes/{id}")
  public XfR putUpdate(@RequestBody FunctionCode functionCode,@PathVariable Long id) {
      functionCode.setId(id);
      return XfR.ok(functionCodeServiceImpl.updateById(functionCode));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param functionCode ${table.comment}
   * @return XfR
   */
  @PatchMapping("/functioncodes/{id}")
  public XfR patchUpdate(@RequestBody FunctionCode functionCode,@PathVariable Long id) {
      FunctionCode upfunctionCode = functionCodeServiceImpl.getById(id);
      if(upfunctionCode != null){
        upfunctionCode = ObjectCopyUtils.copyProperties(functionCode,upfunctionCode,true);
      }
      return XfR.ok(functionCodeServiceImpl.updateById(upfunctionCode));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/functioncodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(functionCodeServiceImpl.removeById(id));
  }

  @PostMapping("/functioncodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "function_code");
     params.put("request", condition);

     return XfR.ok(functionCodeServiceImpl.querys(params));
  }

}
