package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.ProjectFunction;
import com.xforceplus.ultraman.app.imageservicesaas.service.IProjectFunctionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class ProjectFunctionController {

  @Autowired
  private IProjectFunctionService projectFunctionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param projectFunction ${table.comment}
   * @return
   */
  @GetMapping("/projectfunctions" )
  public XfR getProjectFunctions(XfPage page, ProjectFunction projectFunction) {
    return XfR.ok(projectFunctionServiceImpl.page(page, Wrappers.query(projectFunction)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/projectfunctions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectFunctionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param projectFunction ${table.comment}
   * @return XfR
   */
  @PostMapping("/projectfunctions")
  public XfR save(@RequestBody ProjectFunction projectFunction) {
     return XfR.ok(projectFunctionServiceImpl.save(projectFunction));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param projectFunction ${table.comment}
   * @return XfR
   */
  @PutMapping("/projectfunctions/{id}")
  public XfR putUpdate(@RequestBody ProjectFunction projectFunction,@PathVariable Long id) {
      projectFunction.setId(id);
      return XfR.ok(projectFunctionServiceImpl.updateById(projectFunction));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param projectFunction ${table.comment}
   * @return XfR
   */
  @PatchMapping("/projectfunctions/{id}")
  public XfR patchUpdate(@RequestBody ProjectFunction projectFunction,@PathVariable Long id) {
      ProjectFunction upprojectFunction = projectFunctionServiceImpl.getById(id);
      if(upprojectFunction != null){
        upprojectFunction = ObjectCopyUtils.copyProperties(projectFunction,upprojectFunction,true);
      }
      return XfR.ok(projectFunctionServiceImpl.updateById(upprojectFunction));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projectfunctions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectFunctionServiceImpl.removeById(id));
  }

  @PostMapping("/projectfunctions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "project_function");
     params.put("request", condition);

     return XfR.ok(projectFunctionServiceImpl.querys(params));
  }

}
