package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.SystemMenu;
import com.xforceplus.ultraman.app.imageservicesaas.service.ISystemMenuService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 菜单系统对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class SystemMenuController {

  @Autowired
  private ISystemMenuService systemMenuServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemMenu 菜单系统对象
   * @return
   */
  @GetMapping("/systemmenus" )
  public XfR getSystemMenus(XfPage page, SystemMenu systemMenu) {
    return XfR.ok(systemMenuServiceImpl.page(page, Wrappers.query(systemMenu)));
  }

  /**
   * 通过id查询菜单系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemmenus/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemMenuServiceImpl.getById(id));
  }

  /**
   * 新增菜单系统对象
   * @param systemMenu 菜单系统对象
   * @return XfR
   */
  @PostMapping("/systemmenus")
  public XfR save(@RequestBody SystemMenu systemMenu) {
     return XfR.ok(systemMenuServiceImpl.save(systemMenu));
  }

  /**
   * 修改-传入修改后的全部数据菜单系统对象
   * @param systemMenu 菜单系统对象
   * @return XfR
   */
  @PutMapping("/systemmenus/{id}")
  public XfR putUpdate(@RequestBody SystemMenu systemMenu,@PathVariable Long id) {
      systemMenu.setId(id);
      return XfR.ok(systemMenuServiceImpl.updateById(systemMenu));
  }

  /**
   * 修改-传入修改的数据菜单系统对象
   * @param systemMenu 菜单系统对象
   * @return XfR
   */
  @PatchMapping("/systemmenus/{id}")
  public XfR patchUpdate(@RequestBody SystemMenu systemMenu,@PathVariable Long id) {
      SystemMenu upsystemMenu = systemMenuServiceImpl.getById(id);
      if(upsystemMenu != null){
        upsystemMenu = ObjectCopyUtils.copyProperties(systemMenu,upsystemMenu,true);
      }
      return XfR.ok(systemMenuServiceImpl.updateById(upsystemMenu));
  }

  /**
   * 通过id删除菜单系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemmenus/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemMenuServiceImpl.removeById(id));
  }

  @PostMapping("/systemmenus/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_menu");
     params.put("request", condition);

     return XfR.ok(systemMenuServiceImpl.querys(params));
  }

}
