package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.TicketImportDetail;
import com.xforceplus.ultraman.app.imageservicesaas.service.ITicketImportDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketImportDetailController {

  @Autowired
  private ITicketImportDetailService ticketImportDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketImportDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketimportdetails" )
  public XfR getTicketImportDetails(XfPage page, TicketImportDetail ticketImportDetail) {
    return XfR.ok(ticketImportDetailServiceImpl.page(page, Wrappers.query(ticketImportDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketimportdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketImportDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketImportDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketimportdetails")
  public XfR save(@RequestBody TicketImportDetail ticketImportDetail) {
     return XfR.ok(ticketImportDetailServiceImpl.save(ticketImportDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketImportDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketimportdetails/{id}")
  public XfR putUpdate(@RequestBody TicketImportDetail ticketImportDetail,@PathVariable Long id) {
      ticketImportDetail.setId(id);
      return XfR.ok(ticketImportDetailServiceImpl.updateById(ticketImportDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketImportDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketimportdetails/{id}")
  public XfR patchUpdate(@RequestBody TicketImportDetail ticketImportDetail,@PathVariable Long id) {
      TicketImportDetail upticketImportDetail = ticketImportDetailServiceImpl.getById(id);
      if(upticketImportDetail != null){
        upticketImportDetail = ObjectCopyUtils.copyProperties(ticketImportDetail,upticketImportDetail,true);
      }
      return XfR.ok(ticketImportDetailServiceImpl.updateById(upticketImportDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketimportdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketImportDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketimportdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_import_detail");
     params.put("request", condition);

     return XfR.ok(ticketImportDetailServiceImpl.querys(params));
  }

}
