package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.TicketJpcanyinDetail;
import com.xforceplus.ultraman.app.imageservicesaas.service.ITicketJpcanyinDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJpcanyinDetailController {

  @Autowired
  private ITicketJpcanyinDetailService ticketJpcanyinDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJpcanyinDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketjpcanyindetails" )
  public XfR getTicketJpcanyinDetails(XfPage page, TicketJpcanyinDetail ticketJpcanyinDetail) {
    return XfR.ok(ticketJpcanyinDetailServiceImpl.page(page, Wrappers.query(ticketJpcanyinDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjpcanyindetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJpcanyinDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJpcanyinDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjpcanyindetails")
  public XfR save(@RequestBody TicketJpcanyinDetail ticketJpcanyinDetail) {
     return XfR.ok(ticketJpcanyinDetailServiceImpl.save(ticketJpcanyinDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJpcanyinDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjpcanyindetails/{id}")
  public XfR putUpdate(@RequestBody TicketJpcanyinDetail ticketJpcanyinDetail,@PathVariable Long id) {
      ticketJpcanyinDetail.setId(id);
      return XfR.ok(ticketJpcanyinDetailServiceImpl.updateById(ticketJpcanyinDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJpcanyinDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjpcanyindetails/{id}")
  public XfR patchUpdate(@RequestBody TicketJpcanyinDetail ticketJpcanyinDetail,@PathVariable Long id) {
      TicketJpcanyinDetail upticketJpcanyinDetail = ticketJpcanyinDetailServiceImpl.getById(id);
      if(upticketJpcanyinDetail != null){
        upticketJpcanyinDetail = ObjectCopyUtils.copyProperties(ticketJpcanyinDetail,upticketJpcanyinDetail,true);
      }
      return XfR.ok(ticketJpcanyinDetailServiceImpl.updateById(upticketJpcanyinDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjpcanyindetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJpcanyinDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjpcanyindetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jpcanyin_detail");
     params.put("request", condition);

     return XfR.ok(ticketJpcanyinDetailServiceImpl.querys(params));
  }

}
