package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.TicketJpgouwuDetail;
import com.xforceplus.ultraman.app.imageservicesaas.service.ITicketJpgouwuDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJpgouwuDetailController {

  @Autowired
  private ITicketJpgouwuDetailService ticketJpgouwuDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJpgouwuDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketjpgouwudetails" )
  public XfR getTicketJpgouwuDetails(XfPage page, TicketJpgouwuDetail ticketJpgouwuDetail) {
    return XfR.ok(ticketJpgouwuDetailServiceImpl.page(page, Wrappers.query(ticketJpgouwuDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjpgouwudetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJpgouwuDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJpgouwuDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjpgouwudetails")
  public XfR save(@RequestBody TicketJpgouwuDetail ticketJpgouwuDetail) {
     return XfR.ok(ticketJpgouwuDetailServiceImpl.save(ticketJpgouwuDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJpgouwuDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjpgouwudetails/{id}")
  public XfR putUpdate(@RequestBody TicketJpgouwuDetail ticketJpgouwuDetail,@PathVariable Long id) {
      ticketJpgouwuDetail.setId(id);
      return XfR.ok(ticketJpgouwuDetailServiceImpl.updateById(ticketJpgouwuDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJpgouwuDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjpgouwudetails/{id}")
  public XfR patchUpdate(@RequestBody TicketJpgouwuDetail ticketJpgouwuDetail,@PathVariable Long id) {
      TicketJpgouwuDetail upticketJpgouwuDetail = ticketJpgouwuDetailServiceImpl.getById(id);
      if(upticketJpgouwuDetail != null){
        upticketJpgouwuDetail = ObjectCopyUtils.copyProperties(ticketJpgouwuDetail,upticketJpgouwuDetail,true);
      }
      return XfR.ok(ticketJpgouwuDetailServiceImpl.updateById(upticketJpgouwuDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjpgouwudetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJpgouwuDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjpgouwudetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jpgouwu_detail");
     params.put("request", condition);

     return XfR.ok(ticketJpgouwuDetailServiceImpl.querys(params));
  }

}
