package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.TicketJpjiayoufei;
import com.xforceplus.ultraman.app.imageservicesaas.service.ITicketJpjiayoufeiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJpjiayoufeiController {

  @Autowired
  private ITicketJpjiayoufeiService ticketJpjiayoufeiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJpjiayoufei ${table.comment}
   * @return
   */
  @GetMapping("/ticketjpjiayoufeis" )
  public XfR getTicketJpjiayoufeis(XfPage page, TicketJpjiayoufei ticketJpjiayoufei) {
    return XfR.ok(ticketJpjiayoufeiServiceImpl.page(page, Wrappers.query(ticketJpjiayoufei)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjpjiayoufeis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJpjiayoufeiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJpjiayoufei ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjpjiayoufeis")
  public XfR save(@RequestBody TicketJpjiayoufei ticketJpjiayoufei) {
     return XfR.ok(ticketJpjiayoufeiServiceImpl.save(ticketJpjiayoufei));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJpjiayoufei ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjpjiayoufeis/{id}")
  public XfR putUpdate(@RequestBody TicketJpjiayoufei ticketJpjiayoufei,@PathVariable Long id) {
      ticketJpjiayoufei.setId(id);
      return XfR.ok(ticketJpjiayoufeiServiceImpl.updateById(ticketJpjiayoufei));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJpjiayoufei ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjpjiayoufeis/{id}")
  public XfR patchUpdate(@RequestBody TicketJpjiayoufei ticketJpjiayoufei,@PathVariable Long id) {
      TicketJpjiayoufei upticketJpjiayoufei = ticketJpjiayoufeiServiceImpl.getById(id);
      if(upticketJpjiayoufei != null){
        upticketJpjiayoufei = ObjectCopyUtils.copyProperties(ticketJpjiayoufei,upticketJpjiayoufei,true);
      }
      return XfR.ok(ticketJpjiayoufeiServiceImpl.updateById(upticketJpjiayoufei));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjpjiayoufeis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJpjiayoufeiServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjpjiayoufeis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jpjiayoufei");
     params.put("request", condition);

     return XfR.ok(ticketJpjiayoufeiServiceImpl.querys(params));
  }

}
