package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.TicketJptingchefei;
import com.xforceplus.ultraman.app.imageservicesaas.service.ITicketJptingchefeiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJptingchefeiController {

  @Autowired
  private ITicketJptingchefeiService ticketJptingchefeiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJptingchefei ${table.comment}
   * @return
   */
  @GetMapping("/ticketjptingchefeis" )
  public XfR getTicketJptingchefeis(XfPage page, TicketJptingchefei ticketJptingchefei) {
    return XfR.ok(ticketJptingchefeiServiceImpl.page(page, Wrappers.query(ticketJptingchefei)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjptingchefeis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJptingchefeiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJptingchefei ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjptingchefeis")
  public XfR save(@RequestBody TicketJptingchefei ticketJptingchefei) {
     return XfR.ok(ticketJptingchefeiServiceImpl.save(ticketJptingchefei));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJptingchefei ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjptingchefeis/{id}")
  public XfR putUpdate(@RequestBody TicketJptingchefei ticketJptingchefei,@PathVariable Long id) {
      ticketJptingchefei.setId(id);
      return XfR.ok(ticketJptingchefeiServiceImpl.updateById(ticketJptingchefei));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJptingchefei ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjptingchefeis/{id}")
  public XfR patchUpdate(@RequestBody TicketJptingchefei ticketJptingchefei,@PathVariable Long id) {
      TicketJptingchefei upticketJptingchefei = ticketJptingchefeiServiceImpl.getById(id);
      if(upticketJptingchefei != null){
        upticketJptingchefei = ObjectCopyUtils.copyProperties(ticketJptingchefei,upticketJptingchefei,true);
      }
      return XfR.ok(ticketJptingchefeiServiceImpl.updateById(upticketJptingchefei));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjptingchefeis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJptingchefeiServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjptingchefeis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jptingchefei");
     params.put("request", condition);

     return XfR.ok(ticketJptingchefeiServiceImpl.querys(params));
  }

}
