package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.TicketOutTrain;
import com.xforceplus.ultraman.app.imageservicesaas.service.ITicketOutTrainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketOutTrainController {

  @Autowired
  private ITicketOutTrainService ticketOutTrainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketOutTrain ${table.comment}
   * @return
   */
  @GetMapping("/ticketouttrains" )
  public XfR getTicketOutTrains(XfPage page, TicketOutTrain ticketOutTrain) {
    return XfR.ok(ticketOutTrainServiceImpl.page(page, Wrappers.query(ticketOutTrain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketouttrains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketOutTrainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketOutTrain ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketouttrains")
  public XfR save(@RequestBody TicketOutTrain ticketOutTrain) {
     return XfR.ok(ticketOutTrainServiceImpl.save(ticketOutTrain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketOutTrain ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketouttrains/{id}")
  public XfR putUpdate(@RequestBody TicketOutTrain ticketOutTrain,@PathVariable Long id) {
      ticketOutTrain.setId(id);
      return XfR.ok(ticketOutTrainServiceImpl.updateById(ticketOutTrain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketOutTrain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketouttrains/{id}")
  public XfR patchUpdate(@RequestBody TicketOutTrain ticketOutTrain,@PathVariable Long id) {
      TicketOutTrain upticketOutTrain = ticketOutTrainServiceImpl.getById(id);
      if(upticketOutTrain != null){
        upticketOutTrain = ObjectCopyUtils.copyProperties(ticketOutTrain,upticketOutTrain,true);
      }
      return XfR.ok(ticketOutTrainServiceImpl.updateById(upticketOutTrain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketouttrains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketOutTrainServiceImpl.removeById(id));
  }

  @PostMapping("/ticketouttrains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_out_train");
     params.put("request", condition);

     return XfR.ok(ticketOutTrainServiceImpl.querys(params));
  }

}
