package com.xforceplus.ultraman.app.invoiceserviceupgrade.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-03-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class UpgradeConfig implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 租户编码
   */
  @TableField("bizTenantCode")
  private String bizTenantCode;

  /**
   * 公司税号
   */
  @TableField("companyTaxNo")
  private String companyTaxNo;

  /**
   * 门店号码
   */
  @TableField("storeNo")
  private String storeNo;

  /**
   * 配置一
   */
  private String config1;

  /**
   * 配置二
   */
  private String config2;

  /**
   * 配置三
   */
  private String config3;

  /**
   * 配置四
   */
  private String config4;

  /**
   * 配置五
   */
  private String config5;

  /**
   * 租户名称
   */
  @TableField("bizTenantName")
  private String bizTenantName;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 门店名称
   */
  @TableField("storeName")
  private String storeName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 配置六
   */
  private String config6;

  /**
   * 配置七
   */
  private String config7;

  /**
   * 配置八
   */
  private String config8;

  /**
   * 配置九
   */
  private String config9;

  /**
   * 配置十
   */
  private String config10;

  /**
   * 配置十一
   */
  private String config11;

  /**
   * 配置十二
   */
  private String config12;

  /**
   * 平台标记
   */
  @TableField("platformFlag")
  private String platformFlag;

  /**
   * 折扣价格方式
   */
  @TableField("discountType")
  private String discountType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bizTenantCode", bizTenantCode);
      map.put("companyTaxNo", companyTaxNo);
      map.put("storeNo", storeNo);
      map.put("config1", config1);
      map.put("config2", config2);
      map.put("config3", config3);
      map.put("config4", config4);
      map.put("config5", config5);
      map.put("bizTenantName", bizTenantName);
      map.put("companyName", companyName);
      map.put("storeName", storeName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("config6", config6);
      map.put("config7", config7);
      map.put("config8", config8);
      map.put("config9", config9);
      map.put("config10", config10);
      map.put("config11", config11);
      map.put("config12", config12);
      map.put("platformFlag", platformFlag);
      map.put("discountType", discountType);
      return map;
  }

  public static UpgradeConfig fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    UpgradeConfig entity = new UpgradeConfig();
    if(map.containsKey("bizTenantCode")) {
      Object obj = map.get("bizTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBizTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStoreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config1")) {
      Object obj = map.get("config1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config2")) {
      Object obj = map.get("config2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config3")) {
      Object obj = map.get("config3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config4")) {
      Object obj = map.get("config4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config5")) {
      Object obj = map.get("config5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizTenantName")) {
      Object obj = map.get("bizTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBizTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config6")) {
      Object obj = map.get("config6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config7")) {
      Object obj = map.get("config7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config8")) {
      Object obj = map.get("config8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config9")) {
      Object obj = map.get("config9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config10")) {
      Object obj = map.get("config10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config11")) {
      Object obj = map.get("config11");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("config12")) {
      Object obj = map.get("config12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfig12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platformFlag")) {
      Object obj = map.get("platformFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlatformFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountType")) {
      Object obj = map.get("discountType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountType((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bizTenantCode")) {
      Object obj = map.get("bizTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config1")) {
      Object obj = map.get("config1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config2")) {
      Object obj = map.get("config2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config3")) {
      Object obj = map.get("config3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config4")) {
      Object obj = map.get("config4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config5")) {
      Object obj = map.get("config5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizTenantName")) {
      Object obj = map.get("bizTenantName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTenantName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config6")) {
      Object obj = map.get("config6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config7")) {
      Object obj = map.get("config7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config8")) {
      Object obj = map.get("config8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config9")) {
      Object obj = map.get("config9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config10")) {
      Object obj = map.get("config10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config11")) {
      Object obj = map.get("config11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("config12")) {
      Object obj = map.get("config12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfig12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platformFlag")) {
      Object obj = map.get("platformFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlatformFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountType")) {
      Object obj = map.get("discountType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountType((String)obj);
        }
      } else {
      }
    }
  }
}
