package com.xforceplus.ultraman.app.jcaunteajenny.controller;


/**
 * 三方平台账号系统对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcaunteajenny.entity.SystemThirdPartyAccount;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-auntea-jenny")
public interface SystemThirdPartyAccountFeignApi {

  /**
   * 通过id查询三方平台账号系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemThirdPartyAccount/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增三方平台账号系统对象
   * @param systemThirdPartyAccount 三方平台账号系统对象
   * @return R
   */
  @PostMapping("/systemThirdPartyAccount/add")
  public R save(@RequestBody SystemThirdPartyAccount systemThirdPartyAccount);

  /**
   * 修改三方平台账号系统对象
   * @param systemThirdPartyAccount 三方平台账号系统对象
   * @return R
   */
  @PostMapping("/systemThirdPartyAccount/update")
  public R updateById(@RequestBody SystemThirdPartyAccount systemThirdPartyAccount);

  /**
   * 通过id删除三方平台账号系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemThirdPartyAccount/del/{id}" )
  public R removeById(@PathVariable Long id);

}