package com.xforceplus.ultraman.app.jcaunteajenny.controller;


/**
 * feign客户端
 *
 * @author ultraman
 * @date 2025-10-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcaunteajenny.entity.Mat;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-auntea-jenny")
public interface MatFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/mat/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param mat 
   * @return R
   */
  @PostMapping("/mat/add")
  public R save(@RequestBody Mat mat);

  /**
   * 修改
   * @param mat 
   * @return R
   */
  @PostMapping("/mat/update")
  public R updateById(@RequestBody Mat mat);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/mat/del/{id}" )
  public R removeById(@PathVariable Long id);

}