package com.xforceplus.ultraman.app.jcaunteajenny.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * read_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum ReadStatus {

    _0("0", "未读"),
    _1("1", "已读");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReadStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReadStatus fromCode(String code) {
        return Stream.of(ReadStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
