package com.xforceplus.ultraman.app.jcaunteajenny.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * mdm_store
 * </p>
 *
 * @author ultraman
 * @since 2025-10-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MdmStore implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 主数据编码
   */
  private String mdCode;
  /**
   * 主数据描述
   */
  private String mdDescription;
  /**
   * 主数据分类
   */
  private String categoryCode;
  /**
   * 主数据状态
   */
  private String mdStatusCode;
  /**
   * 版本号
   */
  private Long mdVersion;
  /**
   * 抖音门店ID
   */
  private String douyinId;
  /**
   * 饿了么门店ID
   */
  private String elemeId;
  /**
   * 美团外卖门店ID
   */
  private String meituanTakeawayId;
  /**
   * 门店经营类型
   */
  private String storeBusinessType;
  /**
   * 门店经营类型_描述
   */
  private String storeBusinessTypeDesc;
  /**
   * 营业执照附件
   */
  private String bizLicense;
  /**
   * 经营范围
   */
  private String businessScope;
  /**
   * 注册地址/经营场所
   */
  private String regAddress;
  /**
   * 法定代表人
   */
  private String legalRepresentative;
  /**
   * 闭店类型
   */
  private String storeClosureType;
  /**
   * 闭店类型_描述
   */
  private String storeClosureTypeDesc;
  /**
   * 是否内部店
   */
  private String isIndoorStore;
  /**
   * 是否内部店_描述
   */
  private String isIndoorStoreDesc;
  /**
   * 营运教练姓名
   */
  private String opsCoach;
  /**
   * 营运教练工号
   */
  private String opsCoachCode;
  /**
   * 营运专员姓名
   */
  private String opsSpec;
  /**
   * 营运专员工号
   */
  private String opsSpecCode;
  /**
   * 所属子公司名称
   */
  private String subOrgName;
  /**
   * 所属子公司编码
   */
  private String subOrgCode;
  /**
   * 营业结束时间
   */
  private String closingTime;
  /**
   * 营业开始时间
   */
  private String openingTime;
  /**
   * 纬度
   */
  private String latitude;
  /**
   * 经度
   */
  private String longitude;
  /**
   * 详细地址
   */
  private String detailAddress;
  /**
   * 所在区/县
   */
  private String district;
  /**
   * 所在区/县_描述
   */
  private String districtDesc;
  /**
   * 所在市
   */
  private String city;
  /**
   * 所在市_描述
   */
  private String cityDesc;
  /**
   * 所在省
   */
  private String province;
  /**
   * 所在省_描述
   */
  private String provinceDesc;
  /**
   * 国家/地区
   */
  private String countryRegion;
  /**
   * 国家/地区_描述
   */
  private String countryRegionDesc;
  /**
   * 所属加盟商编码
   */
  private String fraCode;
  /**
   * 门店类型
   */
  private String storeType;
  /**
   * 门店类型_描述
   */
  private String storeTypeDesc;
  /**
   * 门店主体性质
   */
  private String storeEntityType;
  /**
   * 门店主体性质_描述
   */
  private String storeEntityTypeDesc;
  /**
   * 旧门店编码
   */
  private String oldStoreNum;
  /**
   * 门店编码
   */
  private String storeCode;
  /**
   * 门店名称
   */
  private String storeName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 主数据ID
   */
  private String mdId;
  /**
   * 开业日期
   */
  private String openingDate;
  /**
   * 品牌
   */
  private String brand;
  /**
   * 拓展1
   */
  private String ext1;
  /**
   * 拓展2
   */
  private String ext2;
  /**
   * 拓展3
   */
  private String ext3;
  /**
   * 营业执照名称
   */
  private String busLicName;
  /**
   * 统一社会信用代码
   */
  private String socialCreditID;
  /**
   * 营业执照地址
   */
  private String busLicAddress;
  /**
   * 营业执照有效期开始日期
   */
  private String busLicRegDate;
  /**
   * 营业执照有效期结束日期
   */
  private String busLicExpDate;
  /**
   * 门店状态描述
   */
  private String newstorestatusText;
  /**
   * 门店状态
   */
  private String newStoreStatus;
  /**
   * 京东ID
   */
  private String jingDongId;
  /**
   * 小程序企迈ID
   */
  private String qimaiID;
  /**
   * 组织树
   */
  private String orgTree;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("mdCode", mdCode);
      map.put("mdDescription", mdDescription);
      map.put("categoryCode", categoryCode);
      map.put("mdStatusCode", mdStatusCode);
      map.put("mdVersion", mdVersion);
      map.put("douyinId", douyinId);
      map.put("elemeId", elemeId);
      map.put("meituanTakeawayId", meituanTakeawayId);
      map.put("storeBusinessType", storeBusinessType);
      map.put("storeBusinessTypeDesc", storeBusinessTypeDesc);
      map.put("bizLicense", bizLicense);
      map.put("businessScope", businessScope);
      map.put("regAddress", regAddress);
      map.put("legalRepresentative", legalRepresentative);
      map.put("storeClosureType", storeClosureType);
      map.put("storeClosureTypeDesc", storeClosureTypeDesc);
      map.put("isIndoorStore", isIndoorStore);
      map.put("isIndoorStoreDesc", isIndoorStoreDesc);
      map.put("opsCoach", opsCoach);
      map.put("opsCoachCode", opsCoachCode);
      map.put("opsSpec", opsSpec);
      map.put("opsSpecCode", opsSpecCode);
      map.put("subOrgName", subOrgName);
      map.put("subOrgCode", subOrgCode);
      map.put("closingTime", closingTime);
      map.put("openingTime", openingTime);
      map.put("latitude", latitude);
      map.put("longitude", longitude);
      map.put("detailAddress", detailAddress);
      map.put("district", district);
      map.put("districtDesc", districtDesc);
      map.put("city", city);
      map.put("cityDesc", cityDesc);
      map.put("province", province);
      map.put("provinceDesc", provinceDesc);
      map.put("countryRegion", countryRegion);
      map.put("countryRegionDesc", countryRegionDesc);
      map.put("fraCode", fraCode);
      map.put("storeType", storeType);
      map.put("storeTypeDesc", storeTypeDesc);
      map.put("storeEntityType", storeEntityType);
      map.put("storeEntityTypeDesc", storeEntityTypeDesc);
      map.put("oldStoreNum", oldStoreNum);
      map.put("storeCode", storeCode);
      map.put("storeName", storeName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("mdId", mdId);
      map.put("openingDate", openingDate);
      map.put("brand", brand);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("busLicName", busLicName);
      map.put("socialCreditID", socialCreditID);
      map.put("busLicAddress", busLicAddress);
      map.put("busLicRegDate", busLicRegDate);
      map.put("busLicExpDate", busLicExpDate);
      map.put("newStoreStatus_text", newstorestatusText);
      map.put("newStoreStatus", newStoreStatus);
      map.put("jingDongId", jingDongId);
      map.put("qimaiID", qimaiID);
      map.put("org_tree", orgTree);

      return map;
  }

  public static MdmStore fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    MdmStore entity = new MdmStore();

    if(map.containsKey("mdCode")) {
      Object obj = map.get("mdCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdDescription")) {
      Object obj = map.get("mdDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdStatusCode")) {
      Object obj = map.get("mdStatusCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdStatusCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdVersion")) {
      Object obj = map.get("mdVersion");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMdVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMdVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMdVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("douyinId")) {
      Object obj = map.get("douyinId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDouyinId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("elemeId")) {
      Object obj = map.get("elemeId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElemeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meituanTakeawayId")) {
      Object obj = map.get("meituanTakeawayId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeituanTakeawayId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeBusinessType")) {
      Object obj = map.get("storeBusinessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeBusinessTypeDesc")) {
      Object obj = map.get("storeBusinessTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreBusinessTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizLicense")) {
      Object obj = map.get("bizLicense");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizLicense((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessScope")) {
      Object obj = map.get("businessScope");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessScope((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regAddress")) {
      Object obj = map.get("regAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legalRepresentative")) {
      Object obj = map.get("legalRepresentative");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLegalRepresentative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeClosureType")) {
      Object obj = map.get("storeClosureType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreClosureType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeClosureTypeDesc")) {
      Object obj = map.get("storeClosureTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreClosureTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isIndoorStore")) {
      Object obj = map.get("isIndoorStore");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsIndoorStore((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isIndoorStoreDesc")) {
      Object obj = map.get("isIndoorStoreDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsIndoorStoreDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsCoach")) {
      Object obj = map.get("opsCoach");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpsCoach((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsCoachCode")) {
      Object obj = map.get("opsCoachCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpsCoachCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsSpec")) {
      Object obj = map.get("opsSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpsSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsSpecCode")) {
      Object obj = map.get("opsSpecCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpsSpecCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subOrgName")) {
      Object obj = map.get("subOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subOrgCode")) {
      Object obj = map.get("subOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("closingTime")) {
      Object obj = map.get("closingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClosingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openingTime")) {
      Object obj = map.get("openingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpeningTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latitude")) {
      Object obj = map.get("latitude");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLatitude((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("longitude")) {
      Object obj = map.get("longitude");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLongitude((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detailAddress")) {
      Object obj = map.get("detailAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDetailAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistrict((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("districtDesc")) {
      Object obj = map.get("districtDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistrictDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cityDesc")) {
      Object obj = map.get("cityDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCityDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("provinceDesc")) {
      Object obj = map.get("provinceDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvinceDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("countryRegion")) {
      Object obj = map.get("countryRegion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountryRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("countryRegionDesc")) {
      Object obj = map.get("countryRegionDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountryRegionDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fraCode")) {
      Object obj = map.get("fraCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFraCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeType")) {
      Object obj = map.get("storeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeTypeDesc")) {
      Object obj = map.get("storeTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeEntityType")) {
      Object obj = map.get("storeEntityType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreEntityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeEntityTypeDesc")) {
      Object obj = map.get("storeEntityTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreEntityTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oldStoreNum")) {
      Object obj = map.get("oldStoreNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOldStoreNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdId")) {
      Object obj = map.get("mdId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openingDate")) {
      Object obj = map.get("openingDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpeningDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busLicName")) {
      Object obj = map.get("busLicName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusLicName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("socialCreditID")) {
      Object obj = map.get("socialCreditID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSocialCreditID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busLicAddress")) {
      Object obj = map.get("busLicAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusLicAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busLicRegDate")) {
      Object obj = map.get("busLicRegDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusLicRegDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busLicExpDate")) {
      Object obj = map.get("busLicExpDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusLicExpDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newStoreStatus_text")) {
      Object obj = map.get("newStoreStatus_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewstorestatusText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newStoreStatus")) {
      Object obj = map.get("newStoreStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewStoreStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jingDongId")) {
      Object obj = map.get("jingDongId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJingDongId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qimaiID")) {
      Object obj = map.get("qimaiID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQimaiID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("mdCode")) {
      Object obj = map.get("mdCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdDescription")) {
      Object obj = map.get("mdDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMdDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdStatusCode")) {
      Object obj = map.get("mdStatusCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMdStatusCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdVersion")) {
      Object obj = map.get("mdVersion");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMdVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMdVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMdVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("douyinId")) {
      Object obj = map.get("douyinId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDouyinId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("elemeId")) {
      Object obj = map.get("elemeId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setElemeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meituanTakeawayId")) {
      Object obj = map.get("meituanTakeawayId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMeituanTakeawayId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeBusinessType")) {
      Object obj = map.get("storeBusinessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeBusinessTypeDesc")) {
      Object obj = map.get("storeBusinessTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreBusinessTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizLicense")) {
      Object obj = map.get("bizLicense");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBizLicense((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessScope")) {
      Object obj = map.get("businessScope");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessScope((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regAddress")) {
      Object obj = map.get("regAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legalRepresentative")) {
      Object obj = map.get("legalRepresentative");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLegalRepresentative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeClosureType")) {
      Object obj = map.get("storeClosureType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreClosureType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeClosureTypeDesc")) {
      Object obj = map.get("storeClosureTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreClosureTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isIndoorStore")) {
      Object obj = map.get("isIndoorStore");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsIndoorStore((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isIndoorStoreDesc")) {
      Object obj = map.get("isIndoorStoreDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsIndoorStoreDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsCoach")) {
      Object obj = map.get("opsCoach");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOpsCoach((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsCoachCode")) {
      Object obj = map.get("opsCoachCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOpsCoachCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsSpec")) {
      Object obj = map.get("opsSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOpsSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsSpecCode")) {
      Object obj = map.get("opsSpecCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOpsSpecCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subOrgName")) {
      Object obj = map.get("subOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subOrgCode")) {
      Object obj = map.get("subOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("closingTime")) {
      Object obj = map.get("closingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClosingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openingTime")) {
      Object obj = map.get("openingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOpeningTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latitude")) {
      Object obj = map.get("latitude");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLatitude((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("longitude")) {
      Object obj = map.get("longitude");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLongitude((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detailAddress")) {
      Object obj = map.get("detailAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDetailAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistrict((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("districtDesc")) {
      Object obj = map.get("districtDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistrictDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cityDesc")) {
      Object obj = map.get("cityDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCityDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("provinceDesc")) {
      Object obj = map.get("provinceDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProvinceDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("countryRegion")) {
      Object obj = map.get("countryRegion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCountryRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("countryRegionDesc")) {
      Object obj = map.get("countryRegionDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCountryRegionDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fraCode")) {
      Object obj = map.get("fraCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFraCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeType")) {
      Object obj = map.get("storeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeTypeDesc")) {
      Object obj = map.get("storeTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeEntityType")) {
      Object obj = map.get("storeEntityType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreEntityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeEntityTypeDesc")) {
      Object obj = map.get("storeEntityTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreEntityTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oldStoreNum")) {
      Object obj = map.get("oldStoreNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOldStoreNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdId")) {
      Object obj = map.get("mdId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMdId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openingDate")) {
      Object obj = map.get("openingDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOpeningDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busLicName")) {
      Object obj = map.get("busLicName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusLicName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("socialCreditID")) {
      Object obj = map.get("socialCreditID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSocialCreditID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busLicAddress")) {
      Object obj = map.get("busLicAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusLicAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busLicRegDate")) {
      Object obj = map.get("busLicRegDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusLicRegDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busLicExpDate")) {
      Object obj = map.get("busLicExpDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusLicExpDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newStoreStatus_text")) {
      Object obj = map.get("newStoreStatus_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNewstorestatusText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newStoreStatus")) {
      Object obj = map.get("newStoreStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNewStoreStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jingDongId")) {
      Object obj = map.get("jingDongId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJingDongId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qimaiID")) {
      Object obj = map.get("qimaiID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQimaiID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
  }
}
