package com.xforceplus.ultraman.app.jcaunteajenny.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcaunteajenny.entity.Mat;
import com.xforceplus.ultraman.app.jcaunteajenny.service.IMatService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2025-10-17
 */
@RestController
public class MatController {

  @Autowired
  private IMatService matServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mat 
   * @return
   */
  @GetMapping("/mats" )
  public XfR getMats(XfPage page, Mat mat) {
    return XfR.ok(matServiceImpl.page(page, Wrappers.query(mat)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/mats/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param mat 
   * @return XfR
   */
  @PostMapping("/mats")
  public XfR save(@RequestBody Mat mat) {
     return XfR.ok(matServiceImpl.save(mat));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param mat 
   * @return XfR
   */
  @PutMapping("/mats/{id}")
  public XfR putUpdate(@RequestBody Mat mat,@PathVariable Long id) {
      mat.setId(id);
      return XfR.ok(matServiceImpl.updateById(mat));
  }

  /**
   * 修改-传入修改的数据
   * @param mat 
   * @return XfR
   */
  @PatchMapping("/mats/{id}")
  public XfR patchUpdate(@RequestBody Mat mat,@PathVariable Long id) {
      Mat upmat = matServiceImpl.getById(id);
      if(upmat != null){
        upmat = ObjectCopyUtils.copyProperties(mat,upmat,true);
      }
      return XfR.ok(matServiceImpl.updateById(upmat));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mats/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matServiceImpl.removeById(id));
  }

  @PostMapping("/mats/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mat");
     params.put("request", condition);

     return XfR.ok(matServiceImpl.querys(params));
  }

}
