package com.xforceplus.ultraman.app.jcaunteajenny.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcaunteajenny.entity.SysFlowIns;
import com.xforceplus.ultraman.app.jcaunteajenny.service.ISysFlowInsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统工作流流程实例对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-20
 */
@RestController
public class SysFlowInsController {

  @Autowired
  private ISysFlowInsService sysFlowInsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysFlowIns 系统工作流流程实例对象
   * @return
   */
  @GetMapping("/sysflowinss" )
  public XfR getSysFlowInss(XfPage page, SysFlowIns sysFlowIns) {
    return XfR.ok(sysFlowInsServiceImpl.page(page, Wrappers.query(sysFlowIns)));
  }

  /**
   * 通过id查询系统工作流流程实例对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysflowinss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysFlowInsServiceImpl.getById(id));
  }

  /**
   * 新增系统工作流流程实例对象
   * @param sysFlowIns 系统工作流流程实例对象
   * @return XfR
   */
  @PostMapping("/sysflowinss")
  public XfR save(@RequestBody SysFlowIns sysFlowIns) {
     return XfR.ok(sysFlowInsServiceImpl.save(sysFlowIns));
  }

  /**
   * 修改-传入修改后的全部数据系统工作流流程实例对象
   * @param sysFlowIns 系统工作流流程实例对象
   * @return XfR
   */
  @PutMapping("/sysflowinss/{id}")
  public XfR putUpdate(@RequestBody SysFlowIns sysFlowIns,@PathVariable Long id) {
      sysFlowIns.setId(id);
      return XfR.ok(sysFlowInsServiceImpl.updateById(sysFlowIns));
  }

  /**
   * 修改-传入修改的数据系统工作流流程实例对象
   * @param sysFlowIns 系统工作流流程实例对象
   * @return XfR
   */
  @PatchMapping("/sysflowinss/{id}")
  public XfR patchUpdate(@RequestBody SysFlowIns sysFlowIns,@PathVariable Long id) {
      SysFlowIns upsysFlowIns = sysFlowInsServiceImpl.getById(id);
      if(upsysFlowIns != null){
        upsysFlowIns = ObjectCopyUtils.copyProperties(sysFlowIns,upsysFlowIns,true);
      }
      return XfR.ok(sysFlowInsServiceImpl.updateById(upsysFlowIns));
  }

  /**
   * 通过id删除系统工作流流程实例对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysflowinss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysFlowInsServiceImpl.removeById(id));
  }

  @PostMapping("/sysflowinss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_flow_ins");
     params.put("request", condition);

     return XfR.ok(sysFlowInsServiceImpl.querys(params));
  }

}
