package com.xforceplus.ultraman.app.jcaunteajenny.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcaunteajenny.entity.MdmStore;
import com.xforceplus.ultraman.app.jcaunteajenny.service.IMdmStoreService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-29
 */
@RestController
public class MdmStoreController {

  @Autowired
  private IMdmStoreService mdmStoreServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mdmStore ${table.comment}
   * @return
   */
  @GetMapping("/mdmstores" )
  public XfR getMdmStores(XfPage page, MdmStore mdmStore) {
    return XfR.ok(mdmStoreServiceImpl.page(page, Wrappers.query(mdmStore)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mdmstores/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mdmStoreServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param mdmStore ${table.comment}
   * @return XfR
   */
  @PostMapping("/mdmstores")
  public XfR save(@RequestBody MdmStore mdmStore) {
     return XfR.ok(mdmStoreServiceImpl.save(mdmStore));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param mdmStore ${table.comment}
   * @return XfR
   */
  @PutMapping("/mdmstores/{id}")
  public XfR putUpdate(@RequestBody MdmStore mdmStore,@PathVariable Long id) {
      mdmStore.setId(id);
      return XfR.ok(mdmStoreServiceImpl.updateById(mdmStore));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param mdmStore ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mdmstores/{id}")
  public XfR patchUpdate(@RequestBody MdmStore mdmStore,@PathVariable Long id) {
      MdmStore upmdmStore = mdmStoreServiceImpl.getById(id);
      if(upmdmStore != null){
        upmdmStore = ObjectCopyUtils.copyProperties(mdmStore,upmdmStore,true);
      }
      return XfR.ok(mdmStoreServiceImpl.updateById(upmdmStore));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mdmstores/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mdmStoreServiceImpl.removeById(id));
  }

  @PostMapping("/mdmstores/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mdm_store");
     params.put("request", condition);

     return XfR.ok(mdmStoreServiceImpl.querys(params));
  }

}
