package com.xforceplus.ultraman.app.jcbabemax.controller;


/**
 * 角色资源绑定关系系统对象feign客户端
 *
 * @author ultraman
 * @date 2025-03-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcbabemax.entity.SystemRelRoleResource;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-babemax")
public interface SystemRelRoleResourceFeignApi {

  /**
   * 通过id查询角色资源绑定关系系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemRelRoleResource/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增角色资源绑定关系系统对象
   * @param systemRelRoleResource 角色资源绑定关系系统对象
   * @return R
   */
  @PostMapping("/systemRelRoleResource/add")
  public R save(@RequestBody SystemRelRoleResource systemRelRoleResource);

  /**
   * 修改角色资源绑定关系系统对象
   * @param systemRelRoleResource 角色资源绑定关系系统对象
   * @return R
   */
  @PostMapping("/systemRelRoleResource/update")
  public R updateById(@RequestBody SystemRelRoleResource systemRelRoleResource);

  /**
   * 通过id删除角色资源绑定关系系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemRelRoleResource/del/{id}" )
  public R removeById(@PathVariable Long id);

}