package com.xforceplus.ultraman.app.jcbabemax.controller;


/**
 * 组织扩展字段系统对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcbabemax.entity.SystemExtendField;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-babemax")
public interface SystemExtendFieldFeignApi {

  /**
   * 通过id查询组织扩展字段系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemExtendField/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增组织扩展字段系统对象
   * @param systemExtendField 组织扩展字段系统对象
   * @return R
   */
  @PostMapping("/systemExtendField/add")
  public R save(@RequestBody SystemExtendField systemExtendField);

  /**
   * 修改组织扩展字段系统对象
   * @param systemExtendField 组织扩展字段系统对象
   * @return R
   */
  @PostMapping("/systemExtendField/update")
  public R updateById(@RequestBody SystemExtendField systemExtendField);

  /**
   * 通过id删除组织扩展字段系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemExtendField/del/{id}" )
  public R removeById(@PathVariable Long id);

}