package com.xforceplus.ultraman.app.jcbabemax.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * compare_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum CompareStatus {

    _0("0", "未比对"),
    _1("1", "比对成功"),
    __1("-1", "比对失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CompareStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompareStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
