package com.xforceplus.ultraman.app.jcbabemax.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_detail_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum OrderDetailStatus {

    _0("0", "待处理"),
    _1("1", "处理成功"),
    _2("2", "已作废"),
    __1("-1", "处理失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OrderDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderDetailStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
