package com.xforceplus.ultraman.app.jcbabemax.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * compare_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum CompareStatus {

    _0("0", "未比对"),
    _1("1", "比对成功"),
    __1("-1", "比对失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CompareStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompareStatus fromCode(String code) {
        return Stream.of(CompareStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
