package com.xforceplus.ultraman.app.jcbabemax.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * main_audit_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum MainAuditStatus {

    _0("0", "待审核"),
    _1("1", "审核完成"),
    _99("99", "待人工审核");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MainAuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MainAuditStatus fromCode(String code) {
        return Stream.of(MainAuditStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
