package com.xforceplus.ultraman.app.jcbabemax.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * manual_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum ManualType {

    _1("1", "同意"),
    _2("2", "驳回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ManualType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ManualType fromCode(String code) {
        return Stream.of(ManualType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
