package com.xforceplus.ultraman.app.jcbabemax.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_detail_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum OrderDetailStatus {

    _0("0", "待处理"),
    _1("1", "处理成功"),
    _2("2", "已作废"),
    __1("-1", "处理失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderDetailStatus fromCode(String code) {
        return Stream.of(OrderDetailStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
