package com.xforceplus.ultraman.app.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcbabemax.entity.OrderDetail;
import com.xforceplus.ultraman.app.jcbabemax.service.IOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class OrderDetailController {

  @Autowired
  private IOrderDetailService orderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderDetail ${table.comment}
   * @return
   */
  @GetMapping("/orderdetails" )
  public XfR getOrderDetails(XfPage page, OrderDetail orderDetail) {
    return XfR.ok(orderDetailServiceImpl.page(page, Wrappers.query(orderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderdetails")
  public XfR save(@RequestBody OrderDetail orderDetail) {
     return XfR.ok(orderDetailServiceImpl.save(orderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderdetails/{id}")
  public XfR putUpdate(@RequestBody OrderDetail orderDetail,@PathVariable Long id) {
      orderDetail.setId(id);
      return XfR.ok(orderDetailServiceImpl.updateById(orderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderdetails/{id}")
  public XfR patchUpdate(@RequestBody OrderDetail orderDetail,@PathVariable Long id) {
      OrderDetail uporderDetail = orderDetailServiceImpl.getById(id);
      if(uporderDetail != null){
        uporderDetail = ObjectCopyUtils.copyProperties(orderDetail,uporderDetail,true);
      }
      return XfR.ok(orderDetailServiceImpl.updateById(uporderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/orderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_detail");
     params.put("request", condition);

     return XfR.ok(orderDetailServiceImpl.querys(params));
  }

}
