package com.xforceplus.ultraman.app.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcbabemax.entity.OrderLog;
import com.xforceplus.ultraman.app.jcbabemax.service.IOrderLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class OrderLogController {

  @Autowired
  private IOrderLogService orderLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderLog ${table.comment}
   * @return
   */
  @GetMapping("/orderlogs" )
  public XfR getOrderLogs(XfPage page, OrderLog orderLog) {
    return XfR.ok(orderLogServiceImpl.page(page, Wrappers.query(orderLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderlogs")
  public XfR save(@RequestBody OrderLog orderLog) {
     return XfR.ok(orderLogServiceImpl.save(orderLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderlogs/{id}")
  public XfR putUpdate(@RequestBody OrderLog orderLog,@PathVariable Long id) {
      orderLog.setId(id);
      return XfR.ok(orderLogServiceImpl.updateById(orderLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderlogs/{id}")
  public XfR patchUpdate(@RequestBody OrderLog orderLog,@PathVariable Long id) {
      OrderLog uporderLog = orderLogServiceImpl.getById(id);
      if(uporderLog != null){
        uporderLog = ObjectCopyUtils.copyProperties(orderLog,uporderLog,true);
      }
      return XfR.ok(orderLogServiceImpl.updateById(uporderLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderLogServiceImpl.removeById(id));
  }

  @PostMapping("/orderlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_log");
     params.put("request", condition);

     return XfR.ok(orderLogServiceImpl.querys(params));
  }

}
