package com.xforceplus.ultraman.app.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcbabemax.entity.PurchaseInvoice;
import com.xforceplus.ultraman.app.jcbabemax.service.IPurchaseInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class PurchaseInvoiceController {

  @Autowired
  private IPurchaseInvoiceService purchaseInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseInvoice ${table.comment}
   * @return
   */
  @GetMapping("/purchaseinvoices" )
  public XfR getPurchaseInvoices(XfPage page, PurchaseInvoice purchaseInvoice) {
    return XfR.ok(purchaseInvoiceServiceImpl.page(page, Wrappers.query(purchaseInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaseinvoices")
  public XfR save(@RequestBody PurchaseInvoice purchaseInvoice) {
     return XfR.ok(purchaseInvoiceServiceImpl.save(purchaseInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaseinvoices/{id}")
  public XfR putUpdate(@RequestBody PurchaseInvoice purchaseInvoice,@PathVariable Long id) {
      purchaseInvoice.setId(id);
      return XfR.ok(purchaseInvoiceServiceImpl.updateById(purchaseInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaseinvoices/{id}")
  public XfR patchUpdate(@RequestBody PurchaseInvoice purchaseInvoice,@PathVariable Long id) {
      PurchaseInvoice uppurchaseInvoice = purchaseInvoiceServiceImpl.getById(id);
      if(uppurchaseInvoice != null){
        uppurchaseInvoice = ObjectCopyUtils.copyProperties(purchaseInvoice,uppurchaseInvoice,true);
      }
      return XfR.ok(purchaseInvoiceServiceImpl.updateById(uppurchaseInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_invoice");
     params.put("request", condition);

     return XfR.ok(purchaseInvoiceServiceImpl.querys(params));
  }

}
