package com.xforceplus.ultraman.app.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcbabemax.entity.PurchaseInvoiceItem;
import com.xforceplus.ultraman.app.jcbabemax.service.IPurchaseInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class PurchaseInvoiceItemController {

  @Autowired
  private IPurchaseInvoiceItemService purchaseInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/purchaseinvoiceitems" )
  public XfR getPurchaseInvoiceItems(XfPage page, PurchaseInvoiceItem purchaseInvoiceItem) {
    return XfR.ok(purchaseInvoiceItemServiceImpl.page(page, Wrappers.query(purchaseInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaseinvoiceitems")
  public XfR save(@RequestBody PurchaseInvoiceItem purchaseInvoiceItem) {
     return XfR.ok(purchaseInvoiceItemServiceImpl.save(purchaseInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaseinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody PurchaseInvoiceItem purchaseInvoiceItem,@PathVariable Long id) {
      purchaseInvoiceItem.setId(id);
      return XfR.ok(purchaseInvoiceItemServiceImpl.updateById(purchaseInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaseinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody PurchaseInvoiceItem purchaseInvoiceItem,@PathVariable Long id) {
      PurchaseInvoiceItem uppurchaseInvoiceItem = purchaseInvoiceItemServiceImpl.getById(id);
      if(uppurchaseInvoiceItem != null){
        uppurchaseInvoiceItem = ObjectCopyUtils.copyProperties(purchaseInvoiceItem,uppurchaseInvoiceItem,true);
      }
      return XfR.ok(purchaseInvoiceItemServiceImpl.updateById(uppurchaseInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_invoice_item");
     params.put("request", condition);

     return XfR.ok(purchaseInvoiceItemServiceImpl.querys(params));
  }

}
