package com.xforceplus.ultraman.app.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcbabemax.entity.SellerInvoiceItem;
import com.xforceplus.ultraman.app.jcbabemax.service.ISellerInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class SellerInvoiceItemController {

  @Autowired
  private ISellerInvoiceItemService sellerInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/sellerinvoiceitems" )
  public XfR getSellerInvoiceItems(XfPage page, SellerInvoiceItem sellerInvoiceItem) {
    return XfR.ok(sellerInvoiceItemServiceImpl.page(page, Wrappers.query(sellerInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sellerInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/sellerinvoiceitems")
  public XfR save(@RequestBody SellerInvoiceItem sellerInvoiceItem) {
     return XfR.ok(sellerInvoiceItemServiceImpl.save(sellerInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sellerInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/sellerinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody SellerInvoiceItem sellerInvoiceItem,@PathVariable Long id) {
      sellerInvoiceItem.setId(id);
      return XfR.ok(sellerInvoiceItemServiceImpl.updateById(sellerInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sellerInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sellerinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody SellerInvoiceItem sellerInvoiceItem,@PathVariable Long id) {
      SellerInvoiceItem upsellerInvoiceItem = sellerInvoiceItemServiceImpl.getById(id);
      if(upsellerInvoiceItem != null){
        upsellerInvoiceItem = ObjectCopyUtils.copyProperties(sellerInvoiceItem,upsellerInvoiceItem,true);
      }
      return XfR.ok(sellerInvoiceItemServiceImpl.updateById(upsellerInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_invoice_item");
     params.put("request", condition);

     return XfR.ok(sellerInvoiceItemServiceImpl.querys(params));
  }

}
