package com.xforceplus.ultraman.app.jcbusinesslabel.controller;


/**
 * 配置目录主表feign客户端
 *
 * @author ultraman
 * @date 2022-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcbusinesslabel.entity.ConfigCatalog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-business-label")
public interface ConfigCatalogFeignApi {

  /**
   * 通过id查询配置目录主表
   * @param  id
   * @return R
   */
  @GetMapping("/configCatalog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增配置目录主表
   * @param configCatalog 配置目录主表
   * @return R
   */
  @PostMapping("/configCatalog/add")
  public R save(@RequestBody ConfigCatalog configCatalog);

  /**
   * 修改配置目录主表
   * @param configCatalog 配置目录主表
   * @return R
   */
  @PostMapping("/configCatalog/update")
  public R updateById(@RequestBody ConfigCatalog configCatalog);

  /**
   * 通过id删除配置目录主表
   * @param  id
   * @return R
   */
  @DeleteMapping("/configCatalog/del/{id}" )
  public R removeById(@PathVariable Long id);

}