package com.xforceplus.ultraman.app.jcbusinesslabel.controller;


/**
 * 配置目录从表feign客户端
 *
 * @author ultraman
 * @date 2022-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcbusinesslabel.entity.ConfigMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-business-label")
public interface ConfigMainFeignApi {

  /**
   * 通过id查询配置目录从表
   * @param  id
   * @return R
   */
  @GetMapping("/configMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增配置目录从表
   * @param configMain 配置目录从表
   * @return R
   */
  @PostMapping("/configMain/add")
  public R save(@RequestBody ConfigMain configMain);

  /**
   * 修改配置目录从表
   * @param configMain 配置目录从表
   * @return R
   */
  @PostMapping("/configMain/update")
  public R updateById(@RequestBody ConfigMain configMain);

  /**
   * 通过id删除配置目录从表
   * @param  id
   * @return R
   */
  @DeleteMapping("/configMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}