package com.xforceplus.ultraman.app.jcbusinesslabel.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理器类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
public enum HandleType {

    RESTAPI_DICTIONARY("restapi_dictionary", "远程字典API"),
    SINK_KAFKA("sink_kafka", "消息下发"),
    BUSINESS_NO("business_no", "业务代码");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    HandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleType fromCode(String code){
        switch(code) {
            case "restapi_dictionary":
                return RESTAPI_DICTIONARY;
            case "sink_kafka":
                return SINK_KAFKA;
            case "business_no":
                return BUSINESS_NO;
            default:
                return null;
        }
    }
}
