package com.xforceplus.ultraman.app.jcbusinesslabel.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 匹配状态
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
public enum MatchStatus {

    _1("1", "不满足条件"),
    _2("2", "匹配失败"),
    _3("3", "已匹配");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MatchStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
