package com.xforceplus.ultraman.app.jcbusinesslabel.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 匹配类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
public enum MatchType {

    AND("and", "满足全部条件（and）"),
    OR("or", "满足任意一个条件（or）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MatchType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchType fromCode(String code){
        switch(code) {
            case "and":
                return AND;
            case "or":
                return OR;
            default:
                return null;
        }
    }
}
