package com.xforceplus.ultraman.app.jcbusinesslabel.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
public enum Type {

    SALES_INVOICE_SYNC_EVENT("sales-invoice-sync-event", "发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Type(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Type fromCode(String code){
        switch(code) {
            case "sales-invoice-sync-event":
                return SALES_INVOICE_SYNC_EVENT;
            default:
                return null;
        }
    }
}
