package com.xforceplus.ultraman.app.jcbusinesslabel.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcbusinesslabel.entity.ConfigCatalog;
import com.xforceplus.ultraman.app.jcbusinesslabel.service.IConfigCatalogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-21
 */
@RestController
public class ConfigCatalogController {

  @Autowired
  private IConfigCatalogService configCatalogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configCatalog ${table.comment}
   * @return
   */
  @GetMapping("/configcatalogs" )
  public XfR getConfigCatalogs(XfPage page, ConfigCatalog configCatalog) {
    return XfR.ok(configCatalogServiceImpl.page(page, Wrappers.query(configCatalog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configcatalogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configCatalogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configCatalog ${table.comment}
   * @return XfR
   */
  @PostMapping("/configcatalogs")
  public XfR save(@RequestBody ConfigCatalog configCatalog) {
     return XfR.ok(configCatalogServiceImpl.save(configCatalog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configCatalog ${table.comment}
   * @return XfR
   */
  @PutMapping("/configcatalogs/{id}")
  public XfR putUpdate(@RequestBody ConfigCatalog configCatalog,@PathVariable Long id) {
      configCatalog.setId(id);
      return XfR.ok(configCatalogServiceImpl.updateById(configCatalog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configCatalog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configcatalogs/{id}")
  public XfR patchUpdate(@RequestBody ConfigCatalog configCatalog,@PathVariable Long id) {
      ConfigCatalog upconfigCatalog = configCatalogServiceImpl.getById(id);
      if(upconfigCatalog != null){
        upconfigCatalog = ObjectCopyUtils.copyProperties(configCatalog,upconfigCatalog,true);
      }
      return XfR.ok(configCatalogServiceImpl.updateById(upconfigCatalog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configcatalogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configCatalogServiceImpl.removeById(id));
  }

  @PostMapping("/configcatalogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_catalog");
     params.put("request", condition);

     return XfR.ok(configCatalogServiceImpl.querys(params));
  }

}
