package com.xforceplus.ultraman.app.jcbusinesslabel.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcbusinesslabel.entity.ErMapping;
import com.xforceplus.ultraman.app.jcbusinesslabel.service.IErMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-21
 */
@RestController
public class ErMappingController {

  @Autowired
  private IErMappingService erMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param erMapping ${table.comment}
   * @return
   */
  @GetMapping("/ermappings" )
  public XfR getErMappings(XfPage page, ErMapping erMapping) {
    return XfR.ok(erMappingServiceImpl.page(page, Wrappers.query(erMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ermappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(erMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param erMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/ermappings")
  public XfR save(@RequestBody ErMapping erMapping) {
     return XfR.ok(erMappingServiceImpl.save(erMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param erMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/ermappings/{id}")
  public XfR putUpdate(@RequestBody ErMapping erMapping,@PathVariable Long id) {
      erMapping.setId(id);
      return XfR.ok(erMappingServiceImpl.updateById(erMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param erMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ermappings/{id}")
  public XfR patchUpdate(@RequestBody ErMapping erMapping,@PathVariable Long id) {
      ErMapping uperMapping = erMappingServiceImpl.getById(id);
      if(uperMapping != null){
        uperMapping = ObjectCopyUtils.copyProperties(erMapping,uperMapping,true);
      }
      return XfR.ok(erMappingServiceImpl.updateById(uperMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ermappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(erMappingServiceImpl.removeById(id));
  }

  @PostMapping("/ermappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "er_mapping");
     params.put("request", condition);

     return XfR.ok(erMappingServiceImpl.querys(params));
  }

}
