package com.xforceplus.ultraman.app.jcbusinesslabel.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcbusinesslabel.entity.ConfigDetail;
import com.xforceplus.ultraman.app.jcbusinesslabel.service.IConfigDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 配置明细表前端控制器
 *
 * @author ultraman
 * @date 2022-11-07
 */
@RestController
public class ConfigDetailController {

  @Autowired
  private IConfigDetailService configDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configDetail 配置明细表
   * @return
   */
  @GetMapping("/configdetails" )
  public XfR getConfigDetails(XfPage page, ConfigDetail configDetail) {
    return XfR.ok(configDetailServiceImpl.page(page, Wrappers.query(configDetail)));
  }

  /**
   * 通过id查询配置明细表
   * @param  id
   * @return XfR
   */
  @GetMapping("/configdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configDetailServiceImpl.getById(id));
  }

  /**
   * 新增配置明细表
   * @param configDetail 配置明细表
   * @return XfR
   */
  @PostMapping("/configdetails")
  public XfR save(@RequestBody ConfigDetail configDetail) {
     return XfR.ok(configDetailServiceImpl.save(configDetail));
  }

  /**
   * 修改-传入修改后的全部数据配置明细表
   * @param configDetail 配置明细表
   * @return XfR
   */
  @PutMapping("/configdetails/{id}")
  public XfR putUpdate(@RequestBody ConfigDetail configDetail,@PathVariable Long id) {
      configDetail.setId(id);
      return XfR.ok(configDetailServiceImpl.updateById(configDetail));
  }

  /**
   * 修改-传入修改的数据配置明细表
   * @param configDetail 配置明细表
   * @return XfR
   */
  @PatchMapping("/configdetails/{id}")
  public XfR patchUpdate(@RequestBody ConfigDetail configDetail,@PathVariable Long id) {
      ConfigDetail upconfigDetail = configDetailServiceImpl.getById(id);
      if(upconfigDetail != null){
        upconfigDetail = ObjectCopyUtils.copyProperties(configDetail,upconfigDetail,true);
      }
      return XfR.ok(configDetailServiceImpl.updateById(upconfigDetail));
  }

  /**
   * 通过id删除配置明细表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configDetailServiceImpl.removeById(id));
  }

  @PostMapping("/configdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_detail");
     params.put("request", condition);

     return XfR.ok(configDetailServiceImpl.querys(params));
  }

}
