package com.xforceplus.ultraman.app.jcbusinesslabel.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcbusinesslabel.entity.ConfigMain;
import com.xforceplus.ultraman.app.jcbusinesslabel.service.IConfigMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 配置目录从表前端控制器
 *
 * @author ultraman
 * @date 2022-11-07
 */
@RestController
public class ConfigMainController {

  @Autowired
  private IConfigMainService configMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configMain 配置目录从表
   * @return
   */
  @GetMapping("/configmains" )
  public XfR getConfigMains(XfPage page, ConfigMain configMain) {
    return XfR.ok(configMainServiceImpl.page(page, Wrappers.query(configMain)));
  }

  /**
   * 通过id查询配置目录从表
   * @param  id
   * @return XfR
   */
  @GetMapping("/configmains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configMainServiceImpl.getById(id));
  }

  /**
   * 新增配置目录从表
   * @param configMain 配置目录从表
   * @return XfR
   */
  @PostMapping("/configmains")
  public XfR save(@RequestBody ConfigMain configMain) {
     return XfR.ok(configMainServiceImpl.save(configMain));
  }

  /**
   * 修改-传入修改后的全部数据配置目录从表
   * @param configMain 配置目录从表
   * @return XfR
   */
  @PutMapping("/configmains/{id}")
  public XfR putUpdate(@RequestBody ConfigMain configMain,@PathVariable Long id) {
      configMain.setId(id);
      return XfR.ok(configMainServiceImpl.updateById(configMain));
  }

  /**
   * 修改-传入修改的数据配置目录从表
   * @param configMain 配置目录从表
   * @return XfR
   */
  @PatchMapping("/configmains/{id}")
  public XfR patchUpdate(@RequestBody ConfigMain configMain,@PathVariable Long id) {
      ConfigMain upconfigMain = configMainServiceImpl.getById(id);
      if(upconfigMain != null){
        upconfigMain = ObjectCopyUtils.copyProperties(configMain,upconfigMain,true);
      }
      return XfR.ok(configMainServiceImpl.updateById(upconfigMain));
  }

  /**
   * 通过id删除配置目录从表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configmains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configMainServiceImpl.removeById(id));
  }

  @PostMapping("/configmains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_main");
     params.put("request", condition);

     return XfR.ok(configMainServiceImpl.querys(params));
  }

}
