package com.xforceplus.ultraman.app.jccainiaoocr.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-06-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccainiaoocr.entity.OcrResult;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cainiao-ocr")
public interface OcrResultFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/ocrResult/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param ocrResult ${table.comment}
   * @return R
   */
  @PostMapping("/ocrResult/add")
  public R save(@RequestBody OcrResult ocrResult);

  /**
   * 修改${table.comment}
   * @param ocrResult ${table.comment}
   * @return R
   */
  @PostMapping("/ocrResult/update")
  public R updateById(@RequestBody OcrResult ocrResult);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/ocrResult/del/{id}" )
  public R removeById(@PathVariable Long id);

}