package com.xforceplus.ultraman.app.jccainiaoocr.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * acquire_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-04
 */
public enum AcquireStatus {

    _0("0", "已上传"),
    _1("1", "处理中"),
    _2("2", "处理失败"),
    _3("3", "待识别"),
    _4("4", "识别中"),
    _5("5", "识别失败"),
    _6("6", "识别成功"),
    _7("7", "获取结果失败"),
    _8("8", "获取结果超时");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AcquireStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AcquireStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
