package com.xforceplus.ultraman.app.jccainiaoocr.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * acquire_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-31
 */
public enum AcquireStatus {

    _0("0", "已上传"),
    _1("1", "处理中"),
    _2("2", "处理失败"),
    _3("3", "待识别"),
    _4("4", "识别中"),
    _5("5", "识别失败"),
    _6("6", "识别成功"),
    _7("7", "获取结果失败"),
    _8("8", "获取结果超时");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AcquireStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AcquireStatus fromCode(String code) {
        return Stream.of(AcquireStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
