package com.xforceplus.ultraman.app.jccainiaoocr.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccainiaoocr.entity.OcrResult;
import com.xforceplus.ultraman.app.jccainiaoocr.service.IOcrResultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-06-20
 */
@RestController
public class OcrResultController {

  @Autowired
  private IOcrResultService ocrResultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ocrResult ${table.comment}
   * @return
   */
  @GetMapping("/ocrresults" )
  public XfR getOcrResults(XfPage page, OcrResult ocrResult) {
    return XfR.ok(ocrResultServiceImpl.page(page, Wrappers.query(ocrResult)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ocrresults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ocrResultServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ocrResult ${table.comment}
   * @return XfR
   */
  @PostMapping("/ocrresults")
  public XfR save(@RequestBody OcrResult ocrResult) {
     return XfR.ok(ocrResultServiceImpl.save(ocrResult));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ocrResult ${table.comment}
   * @return XfR
   */
  @PutMapping("/ocrresults/{id}")
  public XfR putUpdate(@RequestBody OcrResult ocrResult,@PathVariable Long id) {
      ocrResult.setId(id);
      return XfR.ok(ocrResultServiceImpl.updateById(ocrResult));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ocrResult ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ocrresults/{id}")
  public XfR patchUpdate(@RequestBody OcrResult ocrResult,@PathVariable Long id) {
      OcrResult upocrResult = ocrResultServiceImpl.getById(id);
      if(upocrResult != null){
        upocrResult = ObjectCopyUtils.copyProperties(ocrResult,upocrResult,true);
      }
      return XfR.ok(ocrResultServiceImpl.updateById(upocrResult));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ocrresults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ocrResultServiceImpl.removeById(id));
  }

  @PostMapping("/ocrresults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ocr_result");
     params.put("request", condition);

     return XfR.ok(ocrResultServiceImpl.querys(params));
  }

}
