package com.xforceplus.ultraman.app.jccass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 导入库存调整状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public enum ImportInventoryDetailStatus {

    _0("0", "处理中"),
    _1("1", "全部失败"),
    _2("2", "部分成功"),
    _3("3", "全部成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ImportInventoryDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImportInventoryDetailStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
