package com.xforceplus.ultraman.app.jccass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据配单计算依据
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
public enum BillMatchAccordStatus {

    _1("1", "含税金额");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillMatchAccordStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillMatchAccordStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
