package com.xforceplus.ultraman.app.jccass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 商品名称
   */
  private String name;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 规格型号
   */
  private String specification;

  /**
   * 进项单价(不含税)
   */
  private BigDecimal purchasePrice;

  /**
   * 税率
   */
  private BigDecimal taxRate;

  /**
   * 加价比
   */
  private BigDecimal markupRate;

  /**
   * 库存数量
   */
  private BigDecimal stockQuantity;

  /**
   * 销售单价(不含税)
   */
  private BigDecimal salesPrice;

  /**
   * 商品状态
   */
  private String goodsStatus;

  /**
   * 税编
   */
  private String goodsTaxNo;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 文案提示
   */
  private String showMsg;

  /**
   * 单位
   */
  private String unit;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 税编简称
   */
  private String itemShortName;

  /**
   * 商品编码
   */
  private String goodsNo;

  /**
   * 商品id
   */
  private String goodsId;

  /**
   * 销售单价(含税)
   */
  private BigDecimal salesPriceWithTax;

  /**
   * 手工调整数量
   */
  private BigDecimal manualQuantity;

  /**
   * 优惠政策内容
   */
  private String taxPreCon;

  /**
   * 覆盖规则
   */
  private String coverRule;

  /**
   * 商品创建来源
   */
  private String goodsSource;

  /**
   * 原规格型号
   */
  private String specificationOld;

  /**
   * 库存含税金额
   */
  private BigDecimal totalSalesPriceWithTax;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("name", name);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("specification", specification);
      map.put("purchase_price", purchasePrice);
      map.put("tax_rate", taxRate);
      map.put("markup_rate", markupRate);
      map.put("stock_quantity", stockQuantity);
      map.put("sales_price", salesPrice);
      map.put("goods_status", goodsStatus);
      map.put("goods_tax_no", goodsTaxNo);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("show_msg", showMsg);
      map.put("unit", unit);
      map.put("seller_name", sellerName);
      map.put("item_short_name", itemShortName);
      map.put("goods_no", goodsNo);
      map.put("goods_id", goodsId);
      map.put("sales_price_with_tax", salesPriceWithTax);
      map.put("manual_quantity", manualQuantity);
      map.put("tax_pre_con", taxPreCon);
      map.put("cover_rule", coverRule);
      map.put("goods_source", goodsSource);
      map.put("specification_old", specificationOld);
      map.put("total_sales_price_with_tax", totalSalesPriceWithTax);

      return map;
  }

  public static GoodsInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsInfo entity = new GoodsInfo();
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specification")) {
      Object obj = map.get("specification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_price")) {
      Object obj = map.get("purchase_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchasePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchasePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchasePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchasePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchasePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("markup_rate")) {
      Object obj = map.get("markup_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMarkupRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMarkupRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMarkupRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMarkupRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMarkupRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stock_quantity")) {
      Object obj = map.get("stock_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStockQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStockQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStockQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStockQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_price")) {
      Object obj = map.get("sales_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_status")) {
      Object obj = map.get("goods_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("show_msg")) {
      Object obj = map.get("show_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShowMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_short_name")) {
      Object obj = map.get("item_short_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemShortName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_price_with_tax")) {
      Object obj = map.get("sales_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("manual_quantity")) {
      Object obj = map.get("manual_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setManualQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setManualQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setManualQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setManualQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setManualQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre_con")) {
      Object obj = map.get("tax_pre_con");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cover_rule")) {
      Object obj = map.get("cover_rule");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCoverRule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_source")) {
      Object obj = map.get("goods_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specification_old")) {
      Object obj = map.get("specification_old");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecificationOld((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_sales_price_with_tax")) {
      Object obj = map.get("total_sales_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specification")) {
      Object obj = map.get("specification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_price")) {
      Object obj = map.get("purchase_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchasePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchasePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchasePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchasePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchasePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("markup_rate")) {
      Object obj = map.get("markup_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMarkupRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMarkupRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMarkupRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMarkupRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMarkupRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("stock_quantity")) {
      Object obj = map.get("stock_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setStockQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setStockQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setStockQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStockQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setStockQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sales_price")) {
      Object obj = map.get("sales_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goods_status")) {
      Object obj = map.get("goods_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("show_msg")) {
      Object obj = map.get("show_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShowMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_short_name")) {
      Object obj = map.get("item_short_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemShortName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sales_price_with_tax")) {
      Object obj = map.get("sales_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("manual_quantity")) {
      Object obj = map.get("manual_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setManualQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setManualQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setManualQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setManualQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setManualQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_pre_con")) {
      Object obj = map.get("tax_pre_con");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreCon((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cover_rule")) {
      Object obj = map.get("cover_rule");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCoverRule((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_source")) {
      Object obj = map.get("goods_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specification_old")) {
      Object obj = map.get("specification_old");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecificationOld((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_sales_price_with_tax")) {
      Object obj = map.get("total_sales_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
