package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 库存调整方向
 * </p>
 *
 * @author ultraman
 * @since 2023-05-17
 */
public enum InventoryDetailDirection {

    _1("1", "调增"),
    _2("2", "调减");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InventoryDetailDirection(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InventoryDetailDirection fromCode(String code) {
        return Stream.of(InventoryDetailDirection.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
