package com.xforceplus.ultraman.app.jccass.metadata.validator;

import com.xforceplus.ultraman.app.jccass.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jccass.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-05-17
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GoodsStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GoodsStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillMatchAccordStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillMatchAccordStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillMatchAccordStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillMatchDetailStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillMatchDetailStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillMatchDetailStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoMatchPriorityStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AutoMatchPriorityStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AutoMatchPriorityStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryDetailType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InventoryDetailType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InventoryDetailType.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryDetailDirection.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InventoryDetailDirection.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InventoryDetailDirection.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryServiceReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InventoryServiceReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InventoryServiceReason.class.getSimpleName());
            }
        }
        if(clazz.equals(ImportInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImportInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImportInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfirmStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConfirmStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LockStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LockStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(YOrNot.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YOrNot.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RuleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RuleType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
