package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 配单明细匹配条件
 * </p>
 *
 * @author ultraman
 * @since 2023-05-22
 */
public enum BillMatchDetailStatus {

    _1("1", "销方税号"),
    _2("2", "销方名称"),
    _3("3", "商品名称"),
    _4("4", "规格型号"),
    _5("5", "单位"),
    _6("6", "单价"),
    _7("7", "税编简称"),
    _8("8", "税编"),
    _9("9", "税率");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillMatchDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillMatchDetailStatus fromCode(String code) {
        return Stream.of(BillMatchDetailStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
